<?php if (!defined('ABSPATH')) die('No direct access.'); ?>
<div class="aio_blue_box">
	<?php
	echo '<h2>' . esc_html__('What is malware?', 'all-in-one-wp-security-and-firewall').'</h2>';
	echo '<p>' . esc_html__('The word malware stands for malicious software.', 'all-in-one-wp-security-and-firewall') . ' ' . esc_html__('It can consist of things like trojan horses, adware, worms, spyware and any other undesirable code which a hacker will try to inject into your website.', 'all-in-one-wp-security-and-firewall') . '</p>' .'<p>' . esc_html__('Often when malware code has been inserted into your site you will normally not notice anything out of the ordinary based on appearances, but it can have a dramatic effect on your site\'s search ranking.', 'all-in-one-wp-security-and-firewall') . '</p>' .'<p>' . esc_html__('This is because the bots and spiders from search engines such as Google have the capability to detect malware when they are indexing the pages on your site, and consequently they can blacklist your website which will in turn affect your search rankings.', 'all-in-one-wp-security-and-firewall') . '</p>';

	$site_scanners_link = '<a href="https://teamupdraft.com/all-in-one-security/pricing/?utm_source=aios-plugin&utm_medium=referral&utm_campaign=paac&utm_content=learn-more-malware-scan&utm_creative_format=text" target="_blank">' . esc_html__('here', 'all-in-one-wp-security-and-firewall'). '</a>';

	echo '<h2>' . esc_html__('Scanning for malware', 'all-in-one-wp-security-and-firewall') . '</h2>';
	echo '<p>' . esc_html__('Due to the constantly changing and complex nature of Malware, scanning for such things using a standalone plugin will not work reliably.', 'all-in-one-wp-security-and-firewall') . ' ' . esc_html__('This is something best done via an external scan of your site regularly.', 'all-in-one-wp-security-and-firewall') . '</p>'.'<p>'.esc_html__('This is why we have created an easy-to-use scanning service which is hosted off our own server which will scan your site for malware weekly and notify you if it finds anything.', 'all-in-one-wp-security-and-firewall').'</p>';
	echo '<p>' . esc_html__('This service is included with the premium plugin and provides the following:', 'all-in-one-wp-security-and-firewall') . '</p>';
	echo '<ul class="aiowps_admin_ul_grp1">
		<li>' . esc_html__('Automatic weekly scans', 'all-in-one-wp-security-and-firewall') . '</li>
		<li>' . esc_html__('Automatic malware and blacklist monitoring', 'all-in-one-wp-security-and-firewall') . '</li>
		<li>' . esc_html__('Automatic email alerting', 'all-in-one-wp-security-and-firewall') . '</li>
		<li>' . esc_html__('Site uptime monitoring', 'all-in-one-wp-security-and-firewall') . '</li>
		<li>' . esc_html__('Site response time monitoring', 'all-in-one-wp-security-and-firewall') . '</li>
		<li>' . esc_html__('We provide advice for malware cleanup', 'all-in-one-wp-security-and-firewall') . '</li>
		<li>' . esc_html__('Blacklist removal', 'all-in-one-wp-security-and-firewall') . '</li>
		<li>' . esc_html__('No contract (cancel anytime)', 'all-in-one-wp-security-and-firewall') . '</li>
	</ul>';
	/* translators: %s: Scanner URL. */
	echo '<p>' . sprintf(esc_html__('Learn more %s.', 'all-in-one-wp-security-and-firewall'), $site_scanners_link) . '</p>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- variable already escaped.
	?>
</div>